package Daje::Workflow::Activities::Process::Run;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;
use v5.42;

# NAME
# ====
#
# Daje::Workflow::Activities::Process::Run - It's a tool to run a process
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::Activities::Process::Run;
#
#      "activity_data": {
#               "process" : {
#                 "program": "program to run"
#               }
#             }
#
#      Mandatory meta data
#
#      - program to run
#
#
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Activities::Process::Run is a process runner
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

sub execute($self) {

    $self->model->insert_history(
        "Run process",
        "Daje::Workflow::Activities::Process::Run::execute",
        1
    );

    try {
        my $program = $self->activity_data->{process}->{program};
        system $program;
    } catch($e) {
        $self->error->add_error($e);
    };


}
1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Activities::Process::Run - It's a tool to run a process



=head1 SYNOPSIS


    use Daje::Workflow::Activities::Process::Run;

     "activity_data": {
              "process" : {
                "program": "program to run"
              }
            }

     Mandatory meta data

=over

=item *
program to run

=back





=head1 DESCRIPTION


Daje::Workflow::Activities::Process::Run is a process runner



=head1 REQUIRES

L<v5.42> 

L<Mojo::Base> 


=head1 METHODS

=head2 execute($self)

 execute($self)();

NAME
====

Daje::Workflow::Activities::Process::Run - It's a tool to run a process

SYNOPSIS
========

    use Daje::Workflow::Activities::Process::Run;

     "activity_data": {
              "process" : {
                "program": "program to run"
              }
            }

     Mandatory meta data

=over

=item *
program to run

=back



DESCRIPTION
===========

Daje::Workflow::Activities::Process::Run is a process runner

LICENSE
=======

Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

AUTHOR
======

janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

